/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.pt.ipc.sim.impl;

import com.cisco.pt.IPAddress;
import com.cisco.pt.impl.IPCCall;
import com.cisco.pt.impl.IPCMessageLTV;
import com.cisco.pt.impl.IPCResponseLTV;
import com.cisco.pt.ipc.IPCError;
import com.cisco.pt.ipc.IPCFactory;
import com.cisco.pt.ipc.enums.InternetConnectionType;
import com.cisco.pt.ipc.enums.LinksysProtocol;
import com.cisco.pt.ipc.sim.WirelessRouter;
import com.cisco.pt.ipc.sim.impl.RouterImpl;
import com.cisco.pt.ipc.sim.process.nat.NATConfigEntry;
import com.cisco.pt.ptmp.PacketTracerSession;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WirelessRouterImpl
extends RouterImpl
implements WirelessRouter {
    public WirelessRouterImpl(IPCFactory ipcFactory, PacketTracerSession packetTracerSession, IPCMessageLTV accessMessage) {
        super(ipcFactory, packetTracerSession, accessMessage);
    }

    @Override
    public void setDefaultGateway(IPAddress gateway) {
        IPCMessageLTV message = new IPCMessageLTV();
        message.addCalls(this.accessMessage);
        IPCCall newCall = new IPCCall("setDefaultGateway");
        newCall.addIPAddressParameter(gateway);
        message.addCall(newCall);
        this.sendMessageWithReturn(message);
    }

    @Override
    public void setInternetConnectionType(InternetConnectionType type) {
        IPCMessageLTV message = new IPCMessageLTV();
        message.addCalls(this.accessMessage);
        IPCCall newCall = new IPCCall("setInternetConnectionType");
        newCall.addIntParameter(type.getIntValue());
        message.addCall(newCall);
        this.sendMessageWithReturn(message);
    }

    @Override
    public InternetConnectionType getInternetConnectionType() {
        IPCMessageLTV message = new IPCMessageLTV();
        message.addCalls(this.accessMessage);
        IPCCall newCall = new IPCCall("getInternetConnectionType");
        message.addCall(newCall);
        IPCResponseLTV returnMessage = this.sendMessageWithReturn(message);
        if (returnMessage == null) {
            throw new IPCError("Making call on null IPC Object: WirelessRouterImpl.getInternetConnectionType");
        }
        return InternetConnectionType.fromIntValue(returnMessage.getIntValue());
    }

    @Override
    public IPAddress getDefaultGateway() {
        IPCMessageLTV message = new IPCMessageLTV();
        message.addCalls(this.accessMessage);
        IPCCall newCall = new IPCCall("getDefaultGateway");
        message.addCall(newCall);
        IPCResponseLTV returnMessage = this.sendMessageWithReturn(message);
        if (returnMessage == null) {
            return null;
        }
        return (IPAddress)returnMessage.getObjectValue();
    }

    @Override
    public void setRemoteManagementEnable(boolean bEnable) {
        IPCMessageLTV message = new IPCMessageLTV();
        message.addCalls(this.accessMessage);
        IPCCall newCall = new IPCCall("setRemoteManagementEnable");
        newCall.addBoolParameter(bEnable);
        message.addCall(newCall);
        this.sendMessageWithReturn(message);
    }

    @Override
    public boolean isRemoteManagementEnable() {
        IPCMessageLTV message = new IPCMessageLTV();
        message.addCalls(this.accessMessage);
        IPCCall newCall = new IPCCall("isRemoteManagementEnable");
        message.addCall(newCall);
        IPCResponseLTV returnMessage = this.sendMessageWithReturn(message);
        if (returnMessage == null) {
            throw new IPCError("Making call on null IPC Object: WirelessRouterImpl.isRemoteManagementEnable");
        }
        return returnMessage.getBoolValue();
    }

    @Override
    public void addNatEntry(String name, int extPort, int intPort, LinksysProtocol protoType, IPAddress ipAddress, boolean bEnable) {
        IPCMessageLTV message = new IPCMessageLTV();
        message.addCalls(this.accessMessage);
        IPCCall newCall = new IPCCall("addNatEntry");
        newCall.addStringParameter(name);
        newCall.addIntParameter(extPort);
        newCall.addIntParameter(intPort);
        newCall.addIntParameter(protoType.getIntValue());
        newCall.addIPAddressParameter(ipAddress);
        newCall.addBoolParameter(bEnable);
        message.addCall(newCall);
        this.sendMessageWithReturn(message);
    }

    @Override
    public void removeNatEntry(String name, int extPort, int intPort, LinksysProtocol protoType, IPAddress ipAddress, boolean bEnable) {
        IPCMessageLTV message = new IPCMessageLTV();
        message.addCalls(this.accessMessage);
        IPCCall newCall = new IPCCall("removeNatEntry");
        newCall.addStringParameter(name);
        newCall.addIntParameter(extPort);
        newCall.addIntParameter(intPort);
        newCall.addIntParameter(protoType.getIntValue());
        newCall.addIPAddressParameter(ipAddress);
        newCall.addBoolParameter(bEnable);
        message.addCall(newCall);
        this.sendMessageWithReturn(message);
    }

    @Override
    public void removeAllNatEntries() {
        IPCMessageLTV message = new IPCMessageLTV();
        message.addCalls(this.accessMessage);
        IPCCall newCall = new IPCCall("removeAllNatEntries");
        message.addCall(newCall);
        this.sendMessageWithReturn(message);
    }

    @Override
    public int getNatEntryCount() {
        IPCMessageLTV message = new IPCMessageLTV();
        message.addCalls(this.accessMessage);
        IPCCall newCall = new IPCCall("getNatEntryCount");
        message.addCall(newCall);
        IPCResponseLTV returnMessage = this.sendMessageWithReturn(message);
        if (returnMessage == null) {
            throw new IPCError("Making call on null IPC Object: WirelessRouterImpl.getNatEntryCount");
        }
        return returnMessage.getIntValue();
    }

    @Override
    public NATConfigEntry getNatEntryAt(int index) {
        IPCMessageLTV message = new IPCMessageLTV();
        message.addCalls(this.accessMessage);
        IPCCall newCall = new IPCCall("getNatEntryAt");
        newCall.addIntParameter(index);
        message.addCall(newCall);
        IPCResponseLTV returnMessage = this.sendMessageWithReturn(message);
        if (returnMessage == null) {
            return null;
        }
        return (NATConfigEntry)returnMessage.getObjectValue();
    }

    @Override
    public List<NATConfigEntry> getNatEntries() {
        IPCMessageLTV message = new IPCMessageLTV();
        message.addCalls(this.accessMessage);
        IPCCall newCall = new IPCCall("getNatEntries");
        message.addCall(newCall);
        IPCResponseLTV returnMessage = this.sendMessageWithReturn(message);
        List rawList = (List)returnMessage.getObjectValue();
        ArrayList<NATConfigEntry> answer = new ArrayList<NATConfigEntry>();
        for (Object o : rawList) {
            answer.add((NATConfigEntry)o);
        }
        return answer;
    }

    @Override
    public void setFirmwareVersion(String version) {
        IPCMessageLTV message = new IPCMessageLTV();
        message.addCalls(this.accessMessage);
        IPCCall newCall = new IPCCall("setFirmwareVersion");
        newCall.addQStringParameter(version);
        message.addCall(newCall);
        this.sendMessageWithReturn(message);
    }

    @Override
    public String getFirmwareVersion() {
        IPCMessageLTV message = new IPCMessageLTV();
        message.addCalls(this.accessMessage);
        IPCCall newCall = new IPCCall("getFirmwareVersion");
        message.addCall(newCall);
        IPCResponseLTV returnMessage = this.sendMessageWithReturn(message);
        if (returnMessage == null) {
            return null;
        }
        return (String)returnMessage.getObjectValue();
    }

    @Override
    public void setDMZEntry(boolean bEnable, IPAddress ipAddress) {
        IPCMessageLTV message = new IPCMessageLTV();
        message.addCalls(this.accessMessage);
        IPCCall newCall = new IPCCall("setDMZEntry");
        newCall.addBoolParameter(bEnable);
        newCall.addIPAddressParameter(ipAddress);
        message.addCall(newCall);
        this.sendMessageWithReturn(message);
    }

    @Override
    public void removeDMZEntry() {
        IPCMessageLTV message = new IPCMessageLTV();
        message.addCalls(this.accessMessage);
        IPCCall newCall = new IPCCall("removeDMZEntry");
        message.addCall(newCall);
        this.sendMessageWithReturn(message);
    }
}

